
if "%VSCMD_TEST%" NEQ "" goto :test
if "%VSCMD_ARG_CLEAN_ENV%" NEQ "" goto :clean_env

@REM ------------------------------------------------------------------------
:check_platform

if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Checking architecture { host , tgt } : { %VSCMD_ARG_HOST_ARCH% , %VSCMD_ARG_TGT_ARCH% }

@REM Generate folder paths
if /I "%VSCMD_ARG_HOST_ARCH%" == "x86" (
    set __VCVARS_HOST_DIR=\HostX86
    set __VCVARS_HOST_NATIVEDIR=\x86
)
if /I "%VSCMD_ARG_HOST_ARCH%" == "x64" (
    set __VCVARS_HOST_DIR=\HostX64
    set __VCVARS_HOST_NATIVEDIR=\x64
)
if /I "%VSCMD_ARG_HOST_ARCH%" == "arm" (
    set __VCVARS_HOST_DIR=\HostARM
    set __VCVARS_HOST_NATIVEDIR=\arm
)

if /I "%VSCMD_ARG_TGT_ARCH%" == "x86" set __VCVARS_TARGET_DIR=\x86
if /I "%VSCMD_ARG_TGT_ARCH%" == "x64" set __VCVARS_TARGET_DIR=\x64
if /I "%VSCMD_ARG_TGT_ARCH%" == "arm" set __VCVARS_TARGET_DIR=\ARM

if "%__VCVARS_HOST_DIR%" == "" (
	@echo [ERROR:%~nx0] Unknown host architecture '%VSCMD_ARG_HOST_ARCH%'
	set __VCVARS_SCRIPT_ERROR=1
	goto :end
)

if "%__VCVARS_TARGET_DIR%" == "" (
	@echo [ERROR:%~nx0] Unknown target architecture '%VSCMD_ARG_TGT_ARCH%'
	set __VCVARS_SCRIPT_ERROR=1
	goto :end
)

set "__VCVARS_BIN_DIR=%__VCVARS_HOST_DIR%%__VCVARS_TARGET_DIR%"
set "__VCVARS_LIB_DIR=%__VCVARS_TARGET_DIR%"

goto :vcvars_environment

@REM ------------------------------------------------------------------------
:vcvars_environment

if NOT EXIST "%VSINSTALLDIR%VC\" (
    @REM Once this script has been moved into a VC++-specific component, this
    @REM debug message should be converted to an ERROR.
    if "%VSCMD_DEBUG%" GEQ "1" @echo [DEBUG:%~nx0] Could not find directory "%VSINSTALLDIR%VC\"
    goto :end
)

set "VCINSTALLDIR=%VSINSTALLDIR%VC\"
set "VCIDEInstallDir=%VSINSTALLDIR%Common7\IDE\VC\"

goto :export_env

@REM ------------------------------------------------------------------------
:test

set __VSCMD_TEST_FailCount=0

setlocal

@REM -- check for cl.exe on the path --
@echo [TEST:%~nx0] Checking for cl.exe...
where cl.exe > NUL 2>&1
if "%ERRORLEVEL%" NEQ "0" (
    @echo [ERROR:%~nx0] 'where cl.exe' failed
    set /A __VSCMD_TEST_FailCount=__VSCMD_TEST_FailCount+1
)

@REM -- Check for dumpbin.exe on the path.
@REM -- Verifies tools that only exist in native targeting directories
@REM -- are also on the path (for Cross Targeting scenarios)
@echo [TEST:%~nx0] Checking for dumpbin.exe...
where dumpbin.exe > NUL 2>&1
if "%ERRORLEVEL%" NEQ "0" (
    @echo [ERROR:%~nx0] 'where dumpbin.exe' failed
    set /A __VSCMD_TEST_FailCount=__VSCMD_TEST_FailCount+1
)

@REM -- check for msvcrt.lib in LIB --
@echo [TEST:%~nx0] Checking for msvcrt.lib in LIB...
set TEST_LIB=%LIB%
call :test_lib
if "%ERRORLEVEL%" NEQ "0" (
    @echo [ERROR:%~nx0] could not find 'msvcrt.lib' in LIB
    set /A __VSCMD_TEST_FailCount=__VSCMD_TEST_FailCount+1
)

@echo [TEST:%~nx0] Checking for vcruntime.h in INCLUDE...
@REM -- check for vcruntime.h in INCLUDE --
set TEST_INCLUDE=%INCLUDE%
call :test_include
if "%ERRORLEVEL%" NEQ "0" (
    @echo [ERROR:%~nx0] could not find 'vcruntime.h' in INCLUDE
    set /A __VSCMD_TEST_FailCount=__VSCMD_TEST_FailCount+1
)

@REM end local execution and export __vscmd_test_failcount out of the 'setlocal' region
endlocal & set __VSCMD_Test_FailCount=%__VSCMD_TEST_FailCount%

:test_end
if "%__VSCMD_TEST_FailCount%" NEQ "0" (
    set __VSCMD_TEST_FailCount=
    exit /B 1
)

exit /B 0

@REM ------------------------------------------------------------------------
:test_lib

if "%LIB%"=="" (
    @echo [ERROR:%~nx0] LIB environment variable was empty
    exit /B 1
)

for /F "tokens=1* delims=;" %%A in ("%TEST_LIB%") do (

   if EXIST "%%A\msvcrt.lib" (
      exit /B 0
   )

   set TEST_LIB=%%B
   goto :test_lib
)

exit /B 1

@REM ------------------------------------------------------------------------
:test_include
if "%INCLUDE%"=="" (
    @echo [ERROR:%~nx0] INCLUDE environment variable was empty
    exit /B 1
)

for /F "tokens=1* delims=;" %%A in ("%TEST_INCLUDE%") do (

   if EXIST "%%A\vcruntime.h" (
      exit /B 0
   )

   set TEST_INCLUDE=%%B
   goto :test_include
)

exit /B 1

@REM return value other than 0 if tests failed.
if "%__VSCMD_TEST_FailCount%" NEQ "0" (
   set __VSCMD_Test_FailCount=
   exit /B 1
)

set __VSCMD_Test_FailCount=
exit /B 0

:clean_env

set VCINSTALLDIR=
set VCToolsInstallDir=
set VCToolsRedistDir=
set VCIDEInstallDir=
set Platform=
set CommandPromptType=
set PreferredToolArchitecture=
set VCTargetsUnderVCInstall=
set ExtensionSdkDir=

goto :end

@REM ------------------------------------------------------------------------
:export_env

if "%VSCMD_VCVARSALL_INIT%" NEQ "" (
    set Platform=%VSCMD_ARG_TGT_ARCH%
)
if /I "%VSCMD_ARG_HOST_ARCH%" NEQ "%VSCMD_ARG_TGT_ARCH%" (
    set CommandPromptType=Cross
    if /I "%VSCMD_ARG_HOST_ARCH%"=="x64" set PreferredToolArchitecture=x64
) else (
    set CommandPromptType=Native
    set PreferredToolArchitecture=
)

@REM Check for ExtensionSdkDir
@if exist "%ProgramFiles%\Microsoft SDKs\Windows Kits\10\ExtensionSDKs" set ExtensionSdkDir=%ProgramFiles%\Microsoft SDKs\Windows Kits\10\ExtensionSDKs
@if exist "%ProgramFiles(x86)%\Microsoft SDKs\Windows Kits\10\ExtensionSDKs" set ExtensionSdkDir=%ProgramFiles(x86)%\Microsoft SDKs\Windows Kits\10\ExtensionSDKs

@REM Add VCPackages
call :add_to_path_optional "%VSINSTALLDIR%Common7\IDE\VC\VCPackages"

@REM Add MSVC
set "__VCVARS_DEFAULT_CONFIG_FILE=%VCINSTALLDIR%Auxiliary\Build\Microsoft.VCToolsVersion.default.txt"

if not exist "%__VCVARS_DEFAULT_CONFIG_FILE%" (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not find configuration file "%__VCVARS_DEFAULT_CONFIG_FILE%".
    goto :end
)

@REM Use 'type' with double quotes to escape parentheses.
for /F %%A in ('type "%__VCVARS_DEFAULT_CONFIG_FILE%"') do (
    set "__VCVARS_TOOLS_VERSION=%%A"
)

if "%__VCVARS_TOOLS_VERSION%"=="" (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not determine VC++ tools version.
    goto :end
)

if exist "%VCINSTALLDIR%Tools\MSVC\%__VCVARS_TOOLS_VERSION%\" (
    set "VCToolsInstallDir=%VCINSTALLDIR%Tools\MSVC\%__VCVARS_TOOLS_VERSION%\"
) else (
    set VCToolsInstallDir=
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not find VC++ tools version "%__VCVARS_TOOLS_VERSION%" under "%VCINSTALLDIR%Tools\MSVC\".
    goto :end
)

if exist "%VCINSTALLDIR%Redist\MSVC\%__VCVARS_TOOLS_VERSION%\" (
    set "VCToolsRedistDir=%VCINSTALLDIR%Redist\MSVC\%__VCVARS_TOOLS_VERSION%\"
) else (
    set VCToolsRedistDir=
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not find VC++ tools version "%__VCVARS_TOOLS_VERSION%" under "%VCINSTALLDIR%Redist\MSVC\".
    goto :end
)

@REM set the IFCPATH directory for modules
call :set_ifcpath_optional "%VCToolsInstallDir%ifc%__VCVARS_TARGET_DIR%"

@REM for cross compiler scenarios, add the native host compiler toolset directory to PATH
@REM before adding the cross compiler directory.
if /I "%CommandPromptType%"=="Cross" (
    call :add_to_path_optional "%VCToolsInstallDir%bin%__VCVARS_HOST_DIR%%__VCVARS_HOST_NATIVEDIR%"
)
call :add_to_path_optional "%VCToolsInstallDir%bin%__VCVARS_BIN_DIR%"
call :add_to_include_optional "%VCToolsInstallDir%include"
call :add_to_include_optional "%VCToolsInstallDir%ATLMFC\include"

@REM Set LIB based upon target platform
if /I "%VSCMD_ARG_APP_PLAT%"=="Desktop" (
    call :add_to_lib_optional "%VCToolsInstallDir%lib%__VCVARS_LIB_DIR%"
    call :add_to_lib_optional "%VCToolsInstallDir%ATLMFC\lib%__VCVARS_LIB_DIR%"
    call :add_to_libpath_optional "%VCToolsInstallDir%lib%__VCVARS_LIB_DIR%"
    call :add_to_libpath_optional "%VCToolsInstallDir%ATLMFC\lib%__VCVARS_LIB_DIR%"
)

@REM ... set _checkWin81 so it will not match if the Windows 8.1 SDK has been selected/specified.
set "__checkWin81=%WindowsSdkDir:8.1=FOUND%"
if "%__checkWin81%" NEQ	"%WindowsSdkDir%" goto :check_win81_app_platform

@REM Windows 10 SDK only past this point
if /I "%VSCMD_ARG_APP_PLAT%"=="UWP" (
    call :add_to_lib_optional "%VCToolsInstallDir%lib%__VCVARS_LIB_DIR%\store\"
    call :add_to_libpath_optional "%VCToolsInstallDir%lib\x86\store\references"
    call :add_to_libpath_optional "%ExtensionSDKDir%\Microsoft.VCLibs\14.0\References\CommonConfiguration\neutral"
)

if /I "%VSCMD_ARG_APP_PLAT%"=="OneCore" (
    call :add_to_lib_optional "%VCToolsInstallDir%lib\onecore%__VCVARS_LIB_DIR%"
    call :add_to_libpath_optional "%VCToolsInstallDir%lib\onecore%__VCVARS_LIB_DIR%"
)
goto :end

@REM ------------------------------------------------------------------------
:add_to_path_optional
if exist "%~1" (
    set "PATH=%~1;%PATH%"
    exit /B 0
) else (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not add directory to PATH: "%~1"
    exit /B 1
)

@REM ------------------------------------------------------------------------
:add_to_lib_optional
if exist "%~1" (
    set "LIB=%~1;%LIB%"
    exit /B 0
) else (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not add directory to LIB: "%~1"
    exit /B 1
)

@REM ------------------------------------------------------------------------
:add_to_libpath_optional
if exist "%~1" (
    set "LIBPATH=%~1;%LIBPATH%"
    exit /B 0
) else (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not add directory to LIBPATH: "%~1"
    exit /B 1
)

@REM ------------------------------------------------------------------------
:add_to_include_optional
if exist "%~1" (
    set "INCLUDE=%~1;%INCLUDE%"
    exit /B 0
) else (
    if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not add directory to INCLUDE: "%~1"
    exit /B 1
)

@REM ------------------------------------------------------------------------
:set_ifcpath_optional

@REM IFCPATH is expected to be a single path, not a path list. Modules created
@REM by the user (or from another library) would be explicitly referenced via
@REM compiler command line argument.

if "%IFCPATH%"=="" (
    if exist "%~1" (
        set "IFCPATH=%~1"
        exit /B 0
    ) else (
        if "%VSCMD_DEBUG%" GEQ "2" @echo [DEBUG:%~nx0] Could not add directory to IFCPATH: "%~1"
        exit /B 1
    )
) else (
    if "%VSCMD_DEBUG%" GEQ "1" @echo [DEBUG:%~nx0] IFCPATH was not modified. IFCPATH already set: "%IFCPATH%". 
    exit /B 1
)

@REM ------------------------------------------------------------------------
:check_win81_app_platform

if /I "%VSCMD_ARG_APP_PLAT%"=="UWP" goto :report_win81_app_platform_error
if /I "%VSCMD_ARG_APP_PLAT%"=="OneCore" goto :report_win81_app_platform_error

goto :end

:report_win81_app_platform_error
@echo [ERROR:%~nx0] The %VSCMD_ARG_APP_PLAT% Application Platform requires a Windows 10 SDK.
@echo [ERROR:%~nx0] WindowsSdkDir = "%WindowsSdkDir%"
set __VCVARS_SCRIPT_ERROR=1


@REM ------------------------------------------------------------------------
:report_architecture_error

set __VCVARS_SCRIPT_ERROR=1
@echo [ERROR:%~nx0] host/target architecture is not supported : { %VSCMD_ARG_HOST_ARCH% , %VSCMD_ARG_TGT_ARCH% }
goto :end


@REM ------------------------------------------------------------------------
:end
set __VCVARS_HOST_DIR=
set __VCVARS_HOST_NATIVEDIR=
set __VCVARS_TARGET_DIR=
set __VCVARS_BIN_DIR=
set __VCVARS_LIB_DIR=
set __VCVARS_TOOLS_VERSION=
set __VCVARS_DEFAULT_CONFIG_FILE=

set __checkWin81=

if "%__VCVARS_SCRIPT_ERROR%" NEQ "" (
   set __VCVARS_SCRIPT_ERROR=
   exit /B 1
)
exit /B 0